/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core.forge;

import icyllis.annotations.ApiStatus;
import icyllis.modernui.ModernUI;
import icyllis.modernui.core.forge.NetworkHandler;
import icyllis.modernui.core.mixin.AccessFoodData;
import icyllis.modernui.view.UIManager;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ApiStatus.Internal
public final class NetMessages {
    static NetworkHandler network;

    private NetMessages() {
    }

    static void handle(short index, @Nonnull PacketBuffer payload, @Nonnull ServerPlayerEntity player) {
    }

    @Nonnull
    static NetworkHandler.S2CMsgHandler handle() {
        return (x$0, x$1, x$2) -> C.handle(x$0, x$1, x$2);
    }

    @Nonnull
    public static NetworkHandler.Broadcaster food(float foodSaturationLevel, float foodExhaustionLevel) {
        PacketBuffer buf = network.targetAt(0);
        buf.writeFloat(foodSaturationLevel);
        buf.writeFloat(foodExhaustionLevel);
        return network.getBroadcaster(buf);
    }

    @Nonnull
    static NetworkHandler.Broadcaster menu(int containerId, int menuId, Consumer<PacketBuffer> writer) {
        PacketBuffer buf = network.targetAt(1);
        buf.func_150787_b(containerId);
        buf.func_150787_b(menuId);
        if (writer != null) {
            writer.accept(buf);
        }
        return network.getBroadcaster(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class C {
        private C() {
        }

        private static void handle(short index, @Nonnull PacketBuffer payload, @Nonnull ClientPlayerEntity player) {
            switch (index) {
                case 0: {
                    C.food(payload, player);
                    break;
                }
                case 1: {
                    C.menu(payload, player);
                }
            }
        }

        private static void food(@Nonnull PacketBuffer buffer, @Nonnull ClientPlayerEntity player) {
            FoodStats foodData = player.func_71024_bL();
            foodData.func_75119_b(buffer.readFloat());
            ((AccessFoodData)foodData).setExhaustionLevel(buffer.readFloat());
        }

        private static void menu(@Nonnull PacketBuffer buffer, @Nonnull ClientPlayerEntity player) {
            int containerId = buffer.func_150792_a();
            int menuId = buffer.func_150792_a();
            ContainerType type = (ContainerType)Registry.field_218366_G.func_148745_a(menuId);
            boolean success = false;
            if (type == null) {
                ModernUI.LOGGER.warn(UIManager.MARKER, "Trying to open invalid screen for menu id: {}", (Object)menuId);
            } else {
                Container menu = type.create(containerId, player.field_71071_by, buffer);
                ResourceLocation key = Registry.field_218366_G.func_177774_c((Object)type);
                if (menu == null) {
                    ModernUI.LOGGER.error(UIManager.MARKER, "No container menu created from menu type: {}", (Object)key);
                } else if (key != null) {
                    success = UIManager.getInstance().openGUI(player, menu, key.func_110624_b());
                }
            }
            if (!success) {
                player.func_71053_j();
            }
        }
    }
}

